<?php
/**
 * @package     Arastta eCommerce
 * @copyright   2015-2017 Arastta Association. All rights reserved.
 * @copyright   See CREDITS.txt for credits and other copyright notices.
 * @license     GNU GPL version 3; see LICENSE.txt
 * @link        https://arastta.org
 */

 if (defined("LIGHT_ENABLED") or (!defined("LIGHT_FRONTEND") and !file_exists(DIR_LOGS.'cv'))) {if (defined('DIR_CATALOG')) $b = DIR_CATALOG; else $b = DIR_APPLICATION; $b .= 'controller/extension/lightning/beta.php'; if (file_exists($b)) require_once $b;} // Lightning 
class DB {

    private $adapter;

    public function __construct($driver, $hostname, $username, $password, $database) {
 global $db; $db = $this; if (function_exists('Wbu')) { $this->db = Wbu(); $this->adaptor = $this->db; $this->driver = $this->db; return; } // Lightning 
        $class = 'DB\\' . $driver;

        if (class_exists($class)) {
            $this->adapter = new $class($hostname, $username, $password, $database);
        } else {
            exit('Error: Could not load database driver ' . $driver . '!');
        }
    }

    public function query($sql) {
        return $this->adapter->query($sql);
    }

    public function escape($value) {
        return $this->adapter->escape($value);
    }

    public function countAffected() {
        return $this->adapter->countAffected();
    }

    public function getLastId() {
        return $this->adapter->getLastId();
    }

    public function getVersion() {
        return $this->adapter->getVersion();
    }

    public function getCollation() {
        return $this->adapter->getCollation();
    }

    public function setTimezone($timezone) {
        $this->adapter->setTimezone($timezone);
    }
}
