<?php

class AkauntingTransformer
{

    public static function product($row)
    {
        $data = [
            'name'              =>  html_entity_decode($row['name']),
            'description'       =>  html_entity_decode($row['description']),
            'sku'               =>  $row['model'],
            'sale_price'        =>  $row['price'],
            'purchase_price'    =>  $row['price'],
            'quantity'          =>  $row['quantity'],
            'enabled'           =>  $row['status'],
        ];

        return $data;
    }

    public static function customer($row)
    {
        $data = [
            'name'              =>  $row['firstname'] . ' ' . $row['lastname'],
            'email'             =>  $row['email'],
            'phone'             =>  $row['telephone'],
            'address'           =>  $row['address'],
            'enabled'           =>  $row['status'],
        ];

        return $data;
    }

    public static function order($row)
    {
        $data = [
            'invoice_number'        =>  $row['invoice_number'],
            'order_number'          =>  $row['order_id'],
            'invoice_status_code'   =>  'draft',
            'invoiced_at'           =>  $row['date_added'],
            'due_at'                =>  $row['date_added'],
            'amount'                =>  $row['total'],
            'currency_code'         =>  $row['currency_code'],
            'currency_rate'         =>  $row['currency_value'],
            //'customer_id'           =>  $row['customer_id'],
            'customer_name'         =>  $row['firstname'] . ' ' . $row['lastname'],
            'customer_email'        =>  $row['email'],
            'customer_phone'        =>  $row['telephone'],
            'customer_address'      =>  $row['address'],
            'notes'                 =>  $row['comment'],
        ];

        return $data;
    }

    public static function order_product($row)
    {
        $data = [
            'name'                  =>  $row['name'],
            'sku'                   =>  $row['model'],
            'price'                 =>  $row['price'],
            'quantity'              =>  $row['quantity'],
            'tax'                   =>  $row['tax'],
        ];

        return $data;
    }

    public static function order_payment($row)
    {
        $data = [
            'currency_code'         =>  $row['currency_code'],
            'amount'                =>  $row['total'],
            'paid_at'               =>  $row['date_added'],
        ];

        return $data;
    }

    public static function order_total($row)
    {
        $data = [
            'code'                  =>  $row['code'],
            'name'                  =>  $row['title'],
            'amount'                =>  $row['value'],
            'sort_order'            =>  $row['sort_order'],
        ];

        return $data;
    }
}