<?php

class AkauntingConnector
{
    public $email;
    public $password;

    public function __construct($email, $password)
    {
        $this->email = $email;
        $this->password = $password;
    }

    public function get($url)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $this->email . ":" . $this->password);

        return $this->request($ch, 'get');
    }

    public function post($url, $data)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_USERPWD, $this->email . ":" . $this->password);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_HEADER, 1);

        return $this->request($ch, 'post');
    }

    public function patch($url, $data)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
        curl_setopt($ch, CURLOPT_USERPWD, $this->email . ":" . $this->password);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));

        return $this->request($ch, 'patch');
    }

    protected function request($ch, $method = 'get')
    {
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        curl_close($ch);

        if ($method == 'post') {
            $headers = array();

            $data = explode("\n", $response);

            $headers['status'] = $data[0];

            array_shift($data);

            foreach ($data as $part) {
                $middle = explode(': ', $part);

                if (empty($middle[0]) || empty($middle[1])) {
                    continue;
                }

                $headers[trim($middle[0])] = trim($middle[1]);
            }

            return $headers;
        }

        return $response;
    }
}